/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util;

import com.dao.util.BulkInsertHelper;
import com.dto.InvoiceDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import java.util.stream.Collectors;

public class PreInvoiceBulkInsert
extends BulkInsertHelper<InvoiceDto.InvoiceInfo> {
    public PreInvoiceBulkInsert(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected String getIdFieldName() {
        return "FAC_CODE + FAC_TYPE";
    }

    protected boolean getIdentityInsertOn() {
        return false;
    }

    protected List<String> getAllIds(List<InvoiceDto.InvoiceInfo> dtoList) {
        return dtoList.stream().map(dto -> dto.getFac_code() + dto.getType()).collect(Collectors.toList());
    }

    protected String appendInsertValues(InvoiceDto.InvoiceInfo info) {
        return "'" + ConvertStr.nullSafeString((String)info.getId()) + "', '" + ConvertStr.nullSafeString((String)info.getType()) + "', '" + info.getCode() + "', '" + info.getCustomerid() + "', '" + info.getDate() + "', '" + info.getTime() + "', '" + info.getSanadcode() + "', " + info.getSumprice() + ", " + info.getDiscount() + ", '" + info.getUsercode() + "', '" + info.getDateuser() + "', '" + info.getTimeuser() + "', '" + info.getKindvat() + "', " + info.getLevy() + ", " + info.getScot() + ", '" + ConvertStr.nullSafeString((String)info.getComment()) + "', " + ConvertStr.getBoolToInt((Boolean)info.getDelete());
    }

    protected String getTableName() {
        return "FBAILPRE";
    }

    protected String[] getColumnsToInsertInto() {
        return new String[]{"FAC_CODE", "FAC_TYPE", "FAC_CODE_C", "C_CODE", "FAC_DATE", "FAC_TIME", "SANAD_CODE", "SUM_PRICE", "TAKHFIF", "USERCODE", "DATEUSER", "TIMEUSER", "KIND_VAT", "SUM_LEVY", "SUM_SCOT", "FAC_COMMENT", "[DELETE]"};
    }
}

